<?php
// Define the folder and file path
$folderPath = '../Grammarly /'; // Adjust the relative path to the semrush folder
$fileName = 'Grammarly .php';
$filePath = $folderPath . $fileName;

// Initialize variables for input values and read existing data if the file exists
$toolsUrl = '';
$cookies = '';
$dashboardUrl = '';
$notification = '';

if (file_exists($filePath)) {
    $fileContent = file_get_contents($filePath);
    preg_match('/href="([^"]+)"/', $fileContent, $matches);
    $toolsUrl = isset($matches[1]) ? $matches[1] : '';

    preg_match('/<span class="ext01JSONdiv".*?>([^<]+)<\/span>/s', $fileContent, $matches);
    $cookies = isset($matches[1]) ? $matches[1] : '';

    preg_match('/window.location.href = "([^"]+)"/', $fileContent, $matches);
    $dashboardUrl = isset($matches[1]) ? $matches[1] : '';
}

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve input values from the form
    $toolsUrl = $_POST['tools_url'];
    $cookies = $_POST['cookies'];
    $dashboardUrl = $_POST['dashboard_url'];

    // Validate inputs (you can add more validation as needed)
    if (!empty($toolsUrl) && !empty($cookies) && !empty($dashboardUrl)) {
        // Create the content for the PHP file
        $fileContent = <<<PHP
<span class="ext01JSONdiv" href="{$toolsUrl}" style="display:none;">
{$cookies}
</span>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<a class="apsBtn" onclick=""></a>
<script>
    setTimeout(function() {
        document.querySelector('.apsBtn').click();
        window.location.href = "{$dashboardUrl}";
        window.close();
    }, 200);
</script>

<script src="https://cdn.jsdelivr.net/npm/disable-devtool/disable-devtool.min.js"></script>
<script>
    DisableDevtool({
        // The parameters are the same as in 3.1
    })
</script>
PHP;

        // Save the content to the file
        if (file_put_contents($filePath, $fileContent) !== false) {
            $notification = 'Tool updated successfully.';
        } else {
            $notification = 'Error updating the file.';
        }
    } else {
        $notification = 'Please fill in all the fields.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="manifest" href="/site.webmanifest">
    <title>Update Grammarly  File</title>
    <style>
        body {
    font-family: Arial, sans-serif;
    margin: 40px;
    background-color: #fcf0f3;
}

h1 {
    color: #fff;
    background-color: #5b4c29;
    padding: 10px;
    border-radius: 0px;
    width: 1030px;
    margin-left: -41px;
    box-shadow: 0 0 17px 2px rgb(229 54 111 / 87%);
    padding-left: 37px;
}

form {
    margin-top: 20px;
}

textarea {
    width: 90%;
    padding: 10px;
    margin-top: 10px;
    font-size: 16px;
    border: 1px solid #5b4c29;
    border-radius: 5px;
    box-shadow: 0 0 17px 2px rgb(229 54 111 / 25%);
}

input[type="submit"] {
    background-color: #5b4c29;
    color: #fff;
    border: none;
    padding: 12px;
    margin-bottom: 5px;
    margin-top: 20px;
    margin-right: 20px;
    cursor: pointer;
    border-radius: 5px;
    transition: background-color 0.3s;
    font-size: 25px;
    font-weight: bold;
    text-align: left;
    position: relative;
    padding-left: 10px;
    box-shadow: 0 0 17px 2px rgb(229 54 111 / 87%);
    
}

input[type="submit"]:hover {
    background-color: #b1002b; /* Change the color on hover if desired */
    color: #fff;
}

.notification {
    background-color: #008000;
    border-radius: 5px;
    font-size: 16px;
    font-weight: bold;
    color: white;
    padding: 15px;
    margin-top: 10px;
    display: <?php echo isset($notification) ? 'inline-block' : 'none'; ?>;
}

label {
    font-size: 16px;
    font-weight: bold;
    color: white;
    background-color: #5b4c29;
    padding: 5px;
    border: 2px solid #5b4c29;
    border-radius: 5px;
    display: inline-block;
    margin-bottom: 1px;
    margin-top: 30px;
}


/* Apply the same styles as "Add Cookies" to "Add Tools URL" and "Dashboard URL" inputs */

input[type="text"] {
    width: 90%;
    padding: 10px;
    margin-top: 10px;
    font-size: 16px;
    border: 1px solid #5b4c29;
    border-radius: 5px;
    box-shadow: 0 0 17px 2px rgb(229 54 111 / 25%);
}

#clear-cookies-button {
    background-color: #5b4c29;
    color: #fff;
    border: none;
    font-weight: bold;
    padding: 10px 15px; /* Adjust the padding as needed */
    margin-top: 10px;
    font-size: 16px;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.3s;
}

#clear-cookies-button:hover {
    background-color: #b1002b; /* Change the color on hover if desired */
    color: #fff;
}
    </style>
</head>
<body>
    <h1>Update Grammarly  File</h1>
    <?php if (!empty($notification)) : ?>
    <div class="notification" id="notification">
        <?php echo $notification; ?>
    </div>
<?php endif; ?>

    <form method="post">
        <label for="tools_url">Add Tools URL:</label>
        <input type="text" name="tools_url" id="tools_url" value="<?php echo htmlspecialchars($toolsUrl); ?>" required><br>

        <label for="cookies">Add Cookies:</label>
<textarea name="cookies" id="cookies" rows="4" required><?php echo htmlspecialchars($cookies); ?></textarea>
<button id="clear-cookies-button" type="button">Clear Cookies</button><br>


        <label for="dashboard_url">Add Dashboard URL:</label>
        <input type="text" name="dashboard_url" id="dashboard_url" value="<?php echo htmlspecialchars($dashboardUrl); ?>" required><br>

        <input type="submit" value="Update File">
    </form>
    
    <script>
    
    // Function to hide the notification after 3 seconds
function hideNotification() {
    const notification = document.getElementById('notification');
    if (notification) {
        setTimeout(function() {
            notification.style.display = 'none';
        }, 2000); // 2 seconds in milliseconds
    }
}

// Call the hideNotification function after the page loads
window.addEventListener('load', hideNotification);
// Function to clear the cookies input
function clearCookiesInput() {
    const cookiesInput = document.getElementById('cookies');
    cookiesInput.value = ''; // Clear the input value
}

// Add an event listener to the "Clear Cookies" button
const clearCookiesButton = document.getElementById('clear-cookies-button');
clearCookiesButton.addEventListener('click', clearCookiesInput);
</script>

</body>
</html>
